# SQL Interview Practice & Keyboard Shortcuts
## 📸 File History Snapshot (2025-12-05T15:32:36.947Z)
## 📸 File History Snapshot (2025-12-05T15:33:20.368Z)
## 📸 File History Snapshot (2025-12-05T15:45:53.796Z)
## 📸 File History Snapshot (2025-12-05T16:52:53.224Z)
## ◂ USER
  how would you approach this question in an interview?
## ◆ ASSISTANT
  Great question! Let me break down how I'd approach this in an interview setting.
  
  ## Interview Approach: "How would you approach this question?"
  
  When an interviewer asks about your problem-solving approach, they want to see **your thought process**, not just a final answer. Here's the framework I'd use:
  
  ### 1. **Clarify the Question**
  Before diving in, ask clarifying questions:
  - What's the business context? Who needs this data and why?
  - What time range are we looking at?
  - Are there edge cases to consider (nulls, duplicates, data quality)?
  - What's the expected output format?
  
  ### 2. **Think Out Loud**
  Walk through your reasoning:
  - Identify which tables are involved
  - Consider the relationships (joins needed)
  - Think about aggregations, filtering, ordering
  - Mention performance considerations for large datasets
  
  ### 3. **Start Simple, Then Refine**
  - Write a basic version first
  - Add complexity incrementally
  - Validate logic at each step
  
  ### 4. **Consider Edge Cases**
  - NULL handling
  - Empty result sets
  - Data type conversions
  - Boundary conditions
  
  ### 5. **Discuss Trade-offs**
  - Alternative approaches
  - Performance implications (indexes, query plans)
  - Readability vs. optimization
  
  ---
  
  **Do you have a specific SQL question you'd like to practice?** I can walk through it with you using the database schema available here, simulating an interview scenario where we discuss the approach before writing the query.
  Tokens: in=2 out=343 cache=14929
## ◂ USER
  EXAMPLE 1: 
  Given two tables: 
  Table Name - Columns 
  Transactions - transaction_id, customer_id, date, product_id, quantity 
  Product - product_id, product_category, unit_price 
  Q1 - Identify the Top 3 product categories (based on total sales revenue) last month 
## ◆ ASSISTANT
  Great example! Let me walk through how I'd approach this in an interview.
  
  ## Step 1: Clarify the Question
  
  Before writing anything, I'd ask:
  - **"Last month"** - relative to today, or a specific date in the data?
  - **"Total sales revenue"** - is this `quantity * unit_price`, or is there a separate revenue column?
  - **"Top 3"** - how to handle ties? (e.g., if 3rd and 4th have same revenue)
  
  ## Step 2: Identify the Components
  
  - **Tables needed:** Both - Transactions has quantity/dates, Product has category/price
  - **Join:** On `product_id`
  - **Filter:** Date within "last month"
  - **Aggregation:** SUM of revenue, GROUP BY category
  - **Output:** Top 3 by revenue
  
  ## Step 3: Build the Query Incrementally
  
  ```sql
  SELECT 
      p.product_category,
      SUM(t.quantity * p.unit_price) AS total_revenue
  FROM Transactions t
  JOIN Product p ON t.product_id = p.product_id
  WHERE t.date >= DATE_FORMAT(CURDATE() - INTERVAL 1 MONTH, '%Y-%m-01')
    AND t.date < DATE_FORMAT(CURDATE(), '%Y-%m-01')
  GROUP BY p.product_category
  ORDER BY total_revenue DESC
  LIMIT 3;
  ```
  
  ## Step 4: Discuss Trade-offs
  
  **Date handling:** My WHERE clause gets the full previous calendar month. I'd mention alternatives:
  - Rolling 30 days: `WHERE t.date >= CURDATE() - INTERVAL 30 DAY`
  - If data has a known max date, use that instead of `CURDATE()`
  
  **Ties:** `LIMIT 3` arbitrarily cuts off ties. If ties matter:
  ```sql
  -- Use RANK() or DENSE_RANK() instead
  WITH ranked AS (
      SELECT 
          p.product_category,
          SUM(t.quantity * p.unit_price) AS total_revenue,
          RANK() OVER (ORDER BY SUM(t.quantity * p.unit_price) DESC) AS rnk
      FROM Transactions t
      JOIN Product p ON t.product_id = p.product_id
      WHERE t.date >= DATE_FORMAT(CURDATE() - INTERVAL 1 MONTH, '%Y-%m-01')
        AND t.date < DATE_FORMAT(CURDATE(), '%Y-%m-01')
      GROUP BY p.product_category
  )
  SELECT product_category, total_revenue
  FROM ranked
  WHERE rnk <= 3;
  ```
  
  **Performance:** I'd mention that an index on `Transactions(date, product_id)` would help filter and join efficiently.
  
  ---
  
  Want to try a similar question using the tables in this database? I can give you a prompt and we can work through it together.
  Tokens: in=2 out=690 cache=22926
## ◂ USER
  can this handle year boundry? such as, 2025-01-01 as current date , 2024-12-01 last month
## ◆ ASSISTANT
  Great catch! Yes, let's verify.
  
  ## Testing the Year Boundary
  
  If `CURDATE()` is `2025-01-15`:
  
  ```sql
  DATE_FORMAT(CURDATE() - INTERVAL 1 MONTH, '%Y-%m-01')
  -- 2025-01-15 - 1 month = 2024-12-15
  -- DATE_FORMAT(..., '%Y-%m-01') = '2024-12-01' ✓
  
  DATE_FORMAT(CURDATE(), '%Y-%m-01')
  -- = '2025-01-01' ✓
  ```
  
  So the WHERE clause becomes:
  ```sql
  WHERE t.date >= '2024-12-01' AND t.date < '2025-01-01'
  ```
  
  **Yes, it handles the year boundary correctly.**
  
  ## Why This Works
  
  `INTERVAL 1 MONTH` in MySQL/MariaDB is calendar-aware—it properly rolls back across year boundaries. The `DATE_FORMAT(..., '%Y-%m-01')` then normalizes to the first of that month.
  
  ## Alternative Approaches
  
  Some people prefer these for clarity:
  
  ```sql
  -- Using DATE_SUB and LAST_DAY
  WHERE t.date >= DATE_FORMAT(DATE_SUB(CURDATE(), INTERVAL 1 MONTH), '%Y-%m-01')
    AND t.date <= LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))
  
  -- Or using YEAR/MONTH extraction (less efficient but readable)
  WHERE YEAR(t.date) = YEAR(CURDATE() - INTERVAL 1 MONTH)
    AND MONTH(t.date) = MONTH(CURDATE() - INTERVAL 1 MONTH)
  ```
  
  The second approach is easier to read but **can't use indexes** on `date`, so I'd avoid it in an interview unless asked for readability over performance.
  
  Want to test this live against the database here with a similar query?
  Tokens: in=2 out=468 cache=14929
## ◂ USER
  Output the list of customers and the % of their total spend in each product category. what do they mean by "% of their total spend in each product catgory.
## ◆ ASSISTANT
  Great clarifying question! Let me break down what this likely means.
  
  ## Interpreting "% of their total spend in each product category"
  
  This is asking for **each customer's spending distribution across categories**.
  
  ### Example Output
  
  | customer_id | category    | category_spend | total_spend | pct_of_total |
  |-------------|-------------|----------------|-------------|--------------|
  | 101         | Electronics | 500            | 1000        | 50.00%       |
  | 101         | Clothing    | 300            | 1000        | 30.00%       |
  | 101         | Food        | 200            | 1000        | 20.00%       |
  | 102         | Electronics | 800            | 800         | 100.00%      |
  
  For customer 101, their $1000 total is split: 50% Electronics, 30% Clothing, 20% Food.
  
  ## The Query Pattern
  
  ```sql
  SELECT 
      customer_id,
      category,
      SUM(quantity * unit_price) AS category_spend,
      SUM(SUM(quantity * unit_price)) OVER (PARTITION BY customer_id) AS total_spend,
      ROUND(
          100.0 * SUM(quantity * unit_price) / 
          SUM(SUM(quantity * unit_price)) OVER (PARTITION BY customer_id),
          2
      ) AS pct_of_total
  FROM orders o
  JOIN order_items oi ON ...
  JOIN products p ON ...
  GROUP BY customer_id, category;
  ```
  
  The key insight is using a **window function** (`SUM() OVER (PARTITION BY customer_id)`) to get each customer's total while keeping the category-level grouping.
  
  ---
  
  **Interview tip:** When you see ambiguous wording, restate your interpretation: *"Just to confirm—you want each customer's spending broken down by category as a percentage of that customer's total spend, correct?"*
  
  Want to write this query together using the actual schema here (`customers`, `orders`, `order_items`, `products`)?
  Tokens: in=2 out=489 cache=14929
## 📸 File History Snapshot (2025-12-05T17:14:18.508Z)
## ◂ USER
  how would you approach this in an interview?
## ◆ ASSISTANT
  Great question! Here's how I'd walk through this problem out loud in an interview:
  
  ---
  
  ## 1. Clarify the Question
  
  > "Before I start, let me make sure I understand. You want a report showing each customer, the categories they've purchased from, and what percentage of their total spending went to each category—so all percentages for a single customer should sum to 100%. Is that correct?"
  
  Also ask:
  - Should I include customers with no orders?
  - How should I handle NULL categories or zero spend?
  
  ---
  
  ## 2. Identify the Tables & Relationships
  
  > "I'll need to trace from customers to their spending by category..."
  
  - `customers` → `orders` (via `customer_id`)
  - `orders` → `order_items` (via `order_id`)
  - `order_items` → `products` (via `product_id` — this gives us `category`)
  
  Revenue per line item: `quantity * unit_price` (and possibly factor in `discount`)
  
  ---
  
  ## 3. Break It Into Steps
  
  > "I'll approach this in pieces:"
  
  1. **Calculate spend per customer per category** — JOIN the tables, GROUP BY customer + category
  2. **Calculate each customer's total spend** — window function over the grouped result
  3. **Compute the percentage** — category_spend / total_spend * 100
  
  ---
  
  ## 4. Write It Incrementally
  
  **First, get the raw category-level spend:**
  
  ```sql
  SELECT 
      o.customer_id,
      p.category,
      SUM(oi.quantity * oi.unit_price * (1 - oi.discount)) AS category_spend
  FROM orders o
  JOIN order_items oi ON o.id = oi.order_id
  JOIN products p ON oi.product_id = p.id
  GROUP BY o.customer_id, p.category;
  ```
  
  **Then add the window function for total spend and percentage:**
  
  ```sql
  SELECT 
      o.customer_id,
      p.category,
      SUM(oi.quantity * oi.unit_price * (1 - oi.discount)) AS category_spend,
      SUM(SUM(oi.quantity * oi.unit_price * (1 - oi.discount))) 
          OVER (PARTITION BY o.customer_id) AS total_spend,
      ROUND(
          100.0 * SUM(oi.quantity * oi.unit_price * (1 - oi.discount)) /
          SUM(SUM(oi.quantity * oi.unit_price * (1 - oi.discount))) 
              OVER (PARTITION BY o.customer_id),
          2
      ) AS pct_of_total
  FROM orders o
  JOIN order_items oi ON o.id = oi.order_id
  JOIN products p ON oi.product_id = p.id
  GROUP BY o.customer_id, p.category
  ORDER BY o.customer_id, pct_of_total DESC;
  ```
  
  ---
  
  ## 5. Mention Edge Cases & Trade-offs
  
  > "A few things I'd consider:"
  
  - **Division by zero** — if a customer somehow has 0 total spend, wrap in `NULLIF()` or `CASE`
  - **Discount handling** — I included `(1 - discount)` assuming discount is a decimal like 0.10 for 10%
  - **Alternative approach** — could use a CTE or subquery instead of nested window function for readability:
  
  ```sql
  WITH category_spend AS (
      SELECT 
          o.customer_id,
          p.category,
          SUM(oi.quantity * oi.unit_price * (1 - oi.discount)) AS spend
      FROM orders o
      JOIN order_items oi ON o.id = oi.order_id
      JOIN products p ON oi.product_id = p.id
      GROUP BY o.customer_id, p.category
  )
  SELECT 
      customer_id,
      category,
      spend AS category_spend,
      SUM(spend) OVER (PARTITION BY customer_id) AS total_spend,
      ROUND(100.0 * spend / SUM(spend) OVER (PARTITION BY customer_id), 2) AS pct_of_total
  FROM category_spend
  ORDER BY customer_id, pct_of_total DESC;
  ```
  
  > "The CTE version is cleaner—easier to read and debug."
  
  ---
  
  ## Summary: Interview Framework
  
  | Step | What You're Showing |
  |------|---------------------|
  | Clarify | Communication skills, attention to detail |
  | Identify tables | Schema understanding |
  | Break into steps | Structured thinking |
  | Write incrementally | Practical SQL skills |
  | Edge cases & trade-offs | Senior-level awareness |
  
  ---
  
  Want me to run the CTE version against the actual database so you can see the output?
  Tokens: in=2 out=1157 cache=14929
## 📸 File History Snapshot (2025-12-05T17:17:20.429Z)
## ◂ USER
  below is interview questions, how would you approach them?
## ◆ ASSISTANT
  I don't see any interview questions in your message - it looks like the questions didn't come through.
  
  Could you paste them here? I'll walk through my approach for each one.
  Tokens: in=2 out=41 cache=25188
## 📸 File History Snapshot (2025-12-05T17:17:36.224Z)
## ◂ USER
  SQL Query Interview Examples: 
  EXAMPLE 1: 
  Given two tables: 
  Table Name - Columns 
  Transactions - transaction_id, customer_id, date, product_id, quantity 
  Product - product_id, product_category, unit_price 
  Q1 - Identify the Top 3 product categories (based on total sales revenue) last month 
  Q2 - Output the list of customers and the % of their total spend in each product category 
  Q3 - Output the month-over-month (MoM) growth (based on total sales revenue) for each customer 
  EXAMPLE 2 
  Given two tables: 
  Table Name - Columns 
  product - product_category, product_id, and price 
  Transactions - customer_id, date, product_id, and quantity 
  Customer - customer_id, name, address, region, and account_type 
  Q1 - Identify the Top 3 products categories by quantity of items sold in 2019 
  Q2 - What are the Top 5 customers ids in each of the following regions US, EMEA, and APAC, based on the quantity of 
  items sold in the Top 3 categories identified above 
  EXAMPLE 3 
  Given two tables: 
  table name - columns 
  Orders - marketplace_id, order_id, customer_id, item, units, order_date 
  Q1 - Find the percentage of the total orders placed in 2021, which are ordered in Q1 of 2021. 
  Q2 - Get the top 10 items in terms of number of times sold which customers have bought with their first purchase in 
  2021 in the US  
  Other Examples: 
  Q: Write a query that will count the number of unique customers and the average sales amount in November 2021 (01 
  Nov - 30 Nov 2021). 
  Q: Write a query that will count the number of unique customers and the average of customers average sales amount 
  in November 2021 (01 Nov - 30 Nov 2021). 
  Q: The result from the average sales and average of averages sales is different. We see the simple average is $50, and 
  the average of averages is $60. What does this tell us about customers' ordering behavior? 
  Q: Write a query that will produce data used to populate a histogram that shows the how many unique orders 
  customers have during the month of November 2021. Ensure the query provides the count of customers who had zero 
  orders in Nov 2021. 
  Q: Identify the week-ending date within the last year that saw the largest change in the number of customers who 
  ordered in that week versus the prior week.
## ◆ ASSISTANT
  Great set of questions! Let me walk through my interview approach for each one.
  
  ---
  
  ## EXAMPLE 1
  
  ### Q1 - Top 3 product categories by revenue last month
  
  **Clarify:** What defines "last month"? Calendar month or rolling 30 days?
  
  **Approach:**
  - JOIN Transactions → Product on `product_id`
  - Filter to last month
  - Calculate revenue: `quantity * unit_price`
  - GROUP BY category, SUM revenue, ORDER DESC, LIMIT 3
  
  ```sql
  SELECT 
      p.product_category,
      SUM(t.quantity * p.unit_price) AS total_revenue
  FROM Transactions t
  JOIN Product p ON t.product_id = p.product_id
  WHERE t.date >= DATE_FORMAT(CURDATE() - INTERVAL 1 MONTH, '%Y-%m-01')
    AND t.date < DATE_FORMAT(CURDATE(), '%Y-%m-01')
  GROUP BY p.product_category
  ORDER BY total_revenue DESC
  LIMIT 3;
  ```
  
  ---
  
  ### Q2 - Customer spend % by category
  
  **Clarify:** Percentages should sum to 100% per customer, correct?
  
  **Approach:**
  - JOIN tables to get customer + category + spend
  - Use window function to get customer total
  - Calculate percentage
  
  ```sql
  WITH category_spend AS (
      SELECT 
          t.customer_id,
          p.product_category,
          SUM(t.quantity * p.unit_price) AS spend
      FROM Transactions t
      JOIN Product p ON t.product_id = p.product_id
      GROUP BY t.customer_id, p.product_category
  )
  SELECT 
      customer_id,
      product_category,
      spend,
      ROUND(100.0 * spend / SUM(spend) OVER (PARTITION BY customer_id), 2) AS pct_of_total
  FROM category_spend
  ORDER BY customer_id, pct_of_total DESC;
  ```
  
  ---
  
  ### Q3 - Month-over-month growth by customer
  
  **Clarify:** Growth as percentage change? How to handle first month (no prior)?
  
  **Approach:**
  - Aggregate revenue by customer + month
  - Use `LAG()` to get prior month
  - Calculate `(current - prior) / prior * 100`
  
  ```sql
  WITH monthly_revenue AS (
      SELECT 
          t.customer_id,
          DATE_FORMAT(t.date, '%Y-%m-01') AS month,
          SUM(t.quantity * p.unit_price) AS revenue
      FROM Transactions t
      JOIN Product p ON t.product_id = p.product_id
      GROUP BY t.customer_id, DATE_FORMAT(t.date, '%Y-%m-01')
  )
  SELECT 
      customer_id,
      month,
      revenue,
      LAG(revenue) OVER (PARTITION BY customer_id ORDER BY month) AS prev_revenue,
      ROUND(
          100.0 * (revenue - LAG(revenue) OVER (PARTITION BY customer_id ORDER BY month)) /
          NULLIF(LAG(revenue) OVER (PARTITION BY customer_id ORDER BY month), 0),
          2
      ) AS mom_growth_pct
  FROM monthly_revenue
  ORDER BY customer_id, month;
  ```
  
  ---
  
  ## EXAMPLE 2
  
  ### Q1 - Top 3 categories by quantity sold in 2019
  
  **Approach:** Similar to Example 1 Q1, but aggregate `quantity` instead of revenue.
  
  ```sql
  SELECT 
      p.product_category,
      SUM(t.quantity) AS total_quantity
  FROM Transactions t
  JOIN Product p ON t.product_id = p.product_id
  WHERE t.date >= '2019-01-01' AND t.date < '2020-01-01'
  GROUP BY p.product_category
  ORDER BY total_quantity DESC
  LIMIT 3;
  ```
  
  ---
  
  ### Q2 - Top 5 customers per region in those top 3 categories
  
  **Clarify:** Top 5 *per region* or top 5 overall filtered by region?
  
  **Approach:**
  - Use Q1 result as subquery/CTE
  - Filter transactions to those categories
  - JOIN Customer for region
  - RANK within each region, filter to top 5
  
  ```sql
  WITH top_categories AS (
      SELECT p.product_category
      FROM Transactions t
      JOIN Product p ON t.product_id = p.product_id
      WHERE t.date >= '2019-01-01' AND t.date < '2020-01-01'
      GROUP BY p.product_category
      ORDER BY SUM(t.quantity) DESC
      LIMIT 3
  ),
  customer_sales AS (
      SELECT 
          c.customer_id,
          c.region,
          SUM(t.quantity) AS total_qty
      FROM Transactions t
      JOIN Product p ON t.product_id = p.product_id
      JOIN Customer c ON t.customer_id = c.customer_id
      WHERE p.product_category IN (SELECT product_category FROM top_categories)
        AND c.region IN ('US', 'EMEA', 'APAC')
      GROUP BY c.customer_id, c.region
  ),
  ranked AS (
      SELECT 
          customer_id,
          region,
          total_qty,
          ROW_NUMBER() OVER (PARTITION BY region ORDER BY total_qty DESC) AS rn
      FROM customer_sales
  )
  SELECT customer_id, region, total_qty
  FROM ranked
  WHERE rn <= 5
  ORDER BY region, rn;
  ```
  
  ---
  
  ## EXAMPLE 3
  
  ### Q1 - % of 2021 orders that were in Q1 2021
  
  **Approach:** Count Q1 orders, divide by total 2021 orders.
  
  ```sql
  SELECT 
      ROUND(
          100.0 * SUM(CASE WHEN order_date >= '2021-01-01' AND order_date < '2021-04-01' THEN 1 ELSE 0 END) /
          COUNT(*),
          2
      ) AS q1_pct_of_total
  FROM Orders
  WHERE order_date >= '2021-01-01' AND order_date < '2022-01-01';
  ```
  
  ---
  
  ### Q2 - Top 10 items from first purchases in 2021 (US)
  
  **Clarify:** "First purchase" = customer's first order ever, or first in 2021?
  
  **Approach:**
  - Find each customer's first order date in 2021 (US)
  - Get items from those orders
  - Rank by frequency
  
  ```sql
  WITH first_orders AS (
      SELECT customer_id, MIN(order_date) AS first_date
      FROM Orders
      WHERE order_date >= '2021-01-01' AND order_date < '2022-01-01'
        AND marketplace_id = 'US'  -- assuming this identifies US
      GROUP BY customer_id
  )
  SELECT 
      o.item,
      COUNT(*) AS times_sold
  FROM Orders o
  JOIN first_orders fo 
      ON o.customer_id = fo.customer_id 
      AND o.order_date = fo.first_date
  WHERE o.marketplace_id = 'US'
  GROUP BY o.item
  ORDER BY times_sold DESC
  LIMIT 10;
  ```
  
  ---
  
  ## Other Examples
  
  ### Unique customers & average sales (Nov 2021)
  
  ```sql
  SELECT 
      COUNT(DISTINCT customer_id) AS unique_customers,
      AVG(sales_amount) AS avg_sales
  FROM Orders
  WHERE order_date >= '2021-11-01' AND order_date < '2021-12-01';
  ```
  
  ---
  
  ### Average of customer averages (Nov 2021)
  
  ```sql
  WITH customer_avg AS (
      SELECT customer_id, AVG(sales_amount) AS avg_sales
      FROM Orders
      WHERE order_date >= '2021-11-01' AND order_date < '2021-12-01'
      GROUP BY customer_id
  )
  SELECT AVG(avg_sales) AS avg_of_avg_sales
  FROM customer_avg;
  ```
  
  ---
  
  ### Why are they different? (Conceptual)
  
  > "The simple average weights each *transaction* equally. The average of averages weights each *customer* equally.
  >
  > If `$50 < $60`, it means high-volume customers have lower average order values. A few customers placing many small orders pull down the simple average, but in the average-of-averages, they only count once."
  
  **Key insight:** This reveals **customer behavior skew**—some customers order frequently with smaller amounts.
  
  ---
  
  ### Histogram of order counts (including zeros)
  
  **Approach:** Need all customers, LEFT JOIN to Nov orders, count orders, then group by count.
  
  ```sql
  WITH nov_orders AS (
      SELECT customer_id, COUNT(*) AS order_count
      FROM Orders
      WHERE order_date >= '2021-11-01' AND order_date < '2021-12-01'
      GROUP BY customer_id
  ),
  all_customers AS (
      SELECT 
          c.customer_id,
          COALESCE(n.order_count, 0) AS order_count
      FROM Customers c
      LEFT JOIN nov_orders n ON c.customer_id = n.customer_id
  )
  SELECT 
      order_count,
      COUNT(*) AS customer_count
  FROM all_customers
  GROUP BY order_count
  ORDER BY order_count;
  ```
  
  ---
  
  ### Week with largest WoW customer change
  
  **Approach:**
  - Count distinct customers per week
  - Use `LAG()` for prior week
  - Calculate absolute change, find max
  
  ```sql
  WITH weekly_customers AS (
      SELECT 
          DATE(order_date - INTERVAL WEEKDAY(order_date) DAY + INTERVAL 6 DAY) AS week_ending,
          COUNT(DISTINCT customer_id) AS customer_count
      FROM Orders
      WHERE order_date >= CURDATE() - INTERVAL 1 YEAR
      GROUP BY week_ending
  ),
  with_change AS (
      SELECT 
          week_ending,
          customer_count,
          LAG(customer_count) OVER (ORDER BY week_ending) AS prev_count,
          ABS(customer_count - LAG(customer_count) OVER (ORDER BY week_ending)) AS abs_change
      FROM weekly_customers
  )
  SELECT week_ending, customer_count, prev_count, abs_change
  FROM with_change
  ORDER BY abs_change DESC
  LIMIT 1;
  ```
  
  ---
  
  ## Interview Framework Summary
  
  | Step | What to Do |
  |------|------------|
  | **Clarify** | Restate the problem, ask about edge cases |
  | **Identify** | Tables, joins, filters needed |
  | **Decompose** | Break into CTEs or logical steps |
  | **Write** | Start simple, add complexity |
  | **Validate** | Talk through edge cases (NULLs, zeros, ties) |
  | **Optimize** | Mention indexes, alternatives if asked |
  
  ---
  
  Want me to run any of these against the actual database here so you can see real output?
  Tokens: in=2 out=2683 cache=26359
## 📸 File History Snapshot (2025-12-05T17:19:22.337Z)
## ◂ USER
  no i'm good. please generate this into a word file that I can download
## ◆ ASSISTANT
  I'll create a Word document with all these interview questions and approaches for you.
  Tokens: in=2 out=1 cache=27023
## ◆ ASSISTANT
### ▸ Tool: Bash
  (toolu_01VaDjpHzydQFd9Nk3M2wKPY)
    **command:** pip install python-docx -q
    **description:** Install python-docx for Word file creation
  Tokens: in=2 out=101 cache=27023
### ✗ Error
  (toolu_01VaDjpHzydQFd9Nk3M2wKPY)
    Exit code 1
    error: externally-managed-environment
    
    × This environment is externally managed
    ╰─> To install Python packages system-wide, try apt install
        python3-xyz, where xyz is the package you are trying to
        install.
        
        If you wish to install a non-Debian-packaged Python package,
        create a virtual environment using python3 -m venv path/to/venv.
        Then use path/to/venv/bin/python and path/to/venv/bin/pip. Make
        sure you have python3-full installed.
        
        If you wish to install a non-Debian packaged Python application,
        it may be easiest to use pipx install xyz, which will manage a
        virtual environment for you. Make sure you have pipx installed.
        
        See /usr/share/doc/python3.12/README.venv for more information.
    
    note: If you believe this is a mistake, please contact your Python installation or OS distribution provider. You can override this, at the risk of breaking your Python installation or OS, by passing --break-system-packages.
    ... (21 lines total)
## ◆ ASSISTANT
### ▸ Tool: Bash
  (toolu_01Vb2sf6DdVsrsUEqYtNENFq)
    **command:** pip install python-docx -q --break-system-packages
    **description:** Install python-docx with override flag
  Tokens: in=0 out=89 cache=29828
### ✓ Result
  (toolu_01Vb2sf6DdVsrsUEqYtNENFq)
## 📸 File History Snapshot (2025-12-05T17:19:22.337Z)
## ◆ ASSISTANT
### ▸ Tool: Write
  (toolu_01G8KkHx6RN4GxYMEejmw5hG)
    **file_path:** /home/rosy/create_interview_doc.py
    **content:** from docx import Document
    from docx.shared import Inches, Pt
    from docx.enum.text import WD_ALIGN_PARAGRAPH
    from docx.enum.style import WD_STYLE_TYPE
    
    doc = Document()
    
    # Title
    title = doc.add_heading(...
  Tokens: in=0 out=3962 cache=30224
### ✓ Result
  (toolu_01G8KkHx6RN4GxYMEejmw5hG)
    File created successfully at: /home/rosy/create_interview_doc.py
## ◆ ASSISTANT
### ▸ Tool: Bash
  (toolu_01Nhc9Kt44ZqWvXvFZmSDtMp)
    **command:** python3 /home/rosy/create_interview_doc.py
    **description:** Generate the Word document
  Tokens: in=0 out=87 cache=30426
### ✗ Error
  (toolu_01Nhc9Kt44ZqWvXvFZmSDtMp)
    Exit code 1
    Traceback (most recent call last):
      File "/home/rosy/create_interview_doc.py", line 32, in <module>
        doc.add_paragraph('Approach:', style='Intense Emphasis')
      File "/home/rosy/.local/lib/python3.12/site-packages/docx/document.py", line 119, in add_paragraph
        return self._body.add_paragraph(text, style)
               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
      File "/home/rosy/.local/lib/python3.12/site-packages/docx/blkcntnr.py", line 58, in add_paragraph
        paragraph.style = style
        ^^^^^^^^^^^^^^^
      File "/home/rosy/.local/lib/python3.12/site-packages/docx/text/paragraph.py", line 146, in style
        style_id = self.part.get_style_id(style_or_name, WD_STYLE_TYPE.PARAGRAPH)
                   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
      File "/home/rosy/.local/lib/python3.12/site-packages/docx/parts/document.py", line 87, in get_style_id
        return self.styles.get_style_id(style_or_name, style_type)
               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
      File "/home/rosy/.local/lib/python3.12/site-packages/docx/styles/styles.py", line 98, in get_style_id
        return self._get_style_id_from_name(style_or_name, style_type)
               ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
      File "/home/rosy/.local/lib/python3.12/site-packages/docx/styles/styles.py", line 125, in _get_style_id_from_name
    ... (25 lines total)
## ◆ ASSISTANT
### ▸ Tool: Write
  (toolu_01UvFZS5cLtFLvWUJH6HrK8d)
    **file_path:** /home/rosy/create_interview_doc.py
    **content:** from docx import Document
    from docx.shared import Inches, Pt
    from docx.enum.text import WD_ALIGN_PARAGRAPH
    
    doc = Document()
    
    # Title
    title = doc.add_heading('SQL Query Interview Examples', 0)
    title.a...
  Tokens: in=0 out=3941 cache=34401
### ✓ Result
  (toolu_01UvFZS5cLtFLvWUJH6HrK8d)
    The file /home/rosy/create_interview_doc.py has been updated. Here's the result of running `cat -n` on a snippet of the edited file:
         1→from docx import Document
         2→from docx.shared import Inches, Pt
         3→from docx.enum.text import WD_ALIGN_PARAGRAPH
         4→
         5→doc = Document()
         6→
         7→# Title
         8→title = doc.add_heading('SQL Query Interview Examples', 0)
         9→title.alignment = WD_ALIGN_PARAGRAPH.CENTER
        10→
        11→# Helper function to add code blocks
        12→def add_code(doc, code_text):
        13→    p = doc.add_paragraph()
        14→    run = p.add_run(code_text)
        15→    run.font.name = 'Courier New'
        16→    run.font.size = Pt(9)
        17→    p.paragraph_format.left_indent = Inches(0.25)
        18→    return p
        19→
    ... (343 lines total)
## ◆ ASSISTANT
### ▸ Tool: Bash
  (toolu_01FkFcSUkFu8VhWoC9vZABH2)
    **command:** python3 /home/rosy/create_interview_doc.py && chmod 644 /home/rosy/public/sql_interview_guide.docx
    **description:** Generate Word doc and set permissions
  Tokens: in=0 out=110 cache=35081
### ✓ Result
  (toolu_01FkFcSUkFu8VhWoC9vZABH2)
    Document created successfully!
## ◆ ASSISTANT
  Done! Your Word document is ready for download:
  
  **https://files.shitchell.com/~rosy/sql_interview_guide.docx**
  
  The document includes:
  - All 3 example sets with their questions
  - Clarifying questions to ask
  - Step-by-step approaches
  - SQL code solutions
  - The "Other Examples" section (avg vs avg-of-avg, histogram, WoW change)
  - Interview framework summary table
  Tokens: in=0 out=106 cache=44099
